function PageCtrl($scope, $rootScope, StructureJson, PageJson, $location, NotesStorage){
    $scope.pageData = {}
    $scope.pageId = 0;
    $scope.leftPage = true;
    $scope.notes = [];
    $scope.$watch('p', function(v){
        if(v != false && typeof v !== 'undefined')
        {
            $scope.pageId = v['-id'];
            $scope.pageData = PageJson.loadPage(v);
            $scope.leftPage = StructureJson.isLeftPage(v);
        }
    });
    $scope.$watch('pageData.sourceData.id', function(v){
        if(v != false && typeof v !== 'undefined')
        {
            $scope.loadNotes();
        }
    });

//    $scope.$on('NotesSocket:refreshPageNotes', function(event, obj){
//        $scope.$apply();
//    });
    $scope.$on('Notes:hide', function(event, hide){
        NotesStorage.hideShowAllNotes(hide);
    });



    /**
     * Event odpowiadający za załadowanie danych do strony
     */
    $scope.$on('Page:change', function(e, changeData){
        if(changeData.singleView)
        {
            if(!changeData.isLeftPage && changeData.direction == 1)
            {
                $scope.pageData = PageJson.loadPage(($scope.leftPage) ? $scope.$parent.getNextPage(changeData.currentPage) : $scope.$parent.getNextPage($scope.$parent.getNextPage(changeData.currentPage)));
            }

            if(changeData.isLeftPage && changeData.direction == -1)
            {
                $scope.pageData = PageJson.loadPage(($scope.leftPage) ? $scope.$parent.getPreviousPage($scope.$parent.getPreviousPage(changeData.currentPage)) : $scope.$parent.getPreviousPage(changeData.currentPage));
            }
        }
        else
        {
            if(changeData.direction == 1)
            {
                if($scope.leftPage)
                {
                    var nextPage = $scope.$parent.getNextPage($scope.$parent.getNextPage(changeData.currentPage));
                }
                else
                {
                    var nextPage = $scope.$parent.getNextPage($scope.$parent.getNextPage($scope.$parent.getNextPage(changeData.currentPage)));
                }
                $scope.pageData = (nextPage !== false && typeof nextPage !== 'undefined') ? PageJson.loadPage(nextPage) : {};
            }
            else
            {
                if($scope.leftPage)
                {
                    var prevPage = $scope.$parent.getPreviousPage($scope.$parent.getPreviousPage(changeData.currentPage));

                    if(prevPage != false)
                    {
                        $scope.pageData = PageJson.loadPage(prevPage);
                    }
                    else
                    {
                        $scope.pageData = {}
                    }
                }
                else
                {
                    $scope.pageData = PageJson.loadPage($scope.$parent.getPreviousPage(changeData.currentPage));
                }

            }
        }
        $scope.$apply();
    });


    /**
     * Zdarzenie nasłuchujące na przeskok do jakiejś strony
     */
    $scope.$on('Page:jump', function(e, page){
        if(StructureJson.isLeftPage(page))
        {
            if($scope.leftPage)
            {
                $scope.pageData = PageJson.loadPage(page);
            }
            else
            {
                $scope.pageData = PageJson.loadPage(StructureJson.getNextPage(page));
            }
        }
        else
        {
            if($scope.leftPage)
            {
                $scope.pageData = PageJson.loadPage(StructureJson.getPreviousPage(page));
            }
            else
            {
                $scope.pageData = PageJson.loadPage(page);
            }
        }
        $scope.$apply();
    });


    $scope.singlePageWidth = StructureJson.getPageWidth();

    $scope.openActivity = function(Activity){
        $rootScope.$broadcast('Activity:select', Activity);

        switch(Activity.getType())
        {
            case '_link':
                var path = Activity.getContents()[0].getPath();
                window.open(path.replace('to_url:', ''));
                break;
            case '_plink':
                var path = Activity.getContents()[0].getPath();
                $scope.goToPageId(path.replace('to_page_id:', ''));
                break;
            case '_zoom':
            case '_gallery':
                angular.element('#modal-gallery').modal({
                    backdrop: 'static'
                })
                angular.element('#modal-gallery').modal('show');
                break;
            case '_flash':
                $location.path('/task/' + $scope.pageId + '/' + Activity.getId());
                break;
        }
    }

    $scope.openContentsModalWindow = function(contents){
        angular.element('#modal-content').modal('show');
    }


    $scope.goToPageId = function(pageId){
        var targetPage = null;
        for(var i = 0; i < $scope.pages.length; i++)
        {
            if($scope.pages[i]['-id'] == pageId)
            {
                targetPage = $scope.pages[i];
                break;
            }
        }
        $rootScope.$broadcast('Page:beforeJump', targetPage);
    }


    $scope.loadNotes = function(){
        $scope.notes = NotesStorage.getPageNotes($scope.pageData.getId());
    }
}

PageCtrl.$inject = ['$scope', '$rootScope', 'StructureJson', 'PageJson', '$location', 'NotesStorage'];


function ContentCtrl($scope, $rootScope){

}

ContentCtrl.$inject = ['$scope', '$rootScope'];